/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5281;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import twilightforest.TwilightForestMod;
import twilightforest.loot.conditions.IsMinion;
import twilightforest.loot.conditions.ModExists;
import twilightforest.loot.functions.Enchant;
import twilightforest.loot.functions.ModItemSwap;

public class TFTreasure {
    private static final Set<class_2960> TF_LOOT_TABLES = Sets.newHashSet();
    private static final int DEFAULT_PLACE_FLAG = 2;
    public static final TFTreasure SMALL_HOLLOW_HILL = new TFTreasure("hill_1");
    public static final TFTreasure MEDIUM_HOLLOW_HILL = new TFTreasure("hill_2");
    public static final TFTreasure LARGE_HOLLOW_HILL = new TFTreasure("hill_3");
    public static final TFTreasure HEDGE_MAZE = new TFTreasure("hedge_maze");
    public static final TFTreasure FANCY_WELL = new TFTreasure("fancy_well");
    public static final TFTreasure WELL = new TFTreasure("well");
    public static final TFTreasure LABYRINTH_ROOM = new TFTreasure("labyrinth_room");
    public static final TFTreasure LABYRINTH_DEAD_END = new TFTreasure("labyrinth_dead_end");
    public static final TFTreasure TOWER_ROOM = new TFTreasure("tower_room");
    public static final TFTreasure TOWER_LIBRARY = new TFTreasure("tower_library");
    public static final TFTreasure BASEMENT = new TFTreasure("basement");
    public static final TFTreasure FOUNDATION_BASEMENT = new TFTreasure("foundation_basement");
    public static final TFTreasure LABYRINTH_VAULT = new TFTreasure("labyrinth_vault");
    public static final TFTreasure DARKTOWER_CACHE = new TFTreasure("darktower_cache");
    public static final TFTreasure DARKTOWER_KEY = new TFTreasure("darktower_key");
    public static final TFTreasure DARKTOWER_BOSS = new TFTreasure("darktower_boss");
    public static final TFTreasure TREE_CACHE = new TFTreasure("tree_cache");
    public static final TFTreasure STRONGHOLD_CACHE = new TFTreasure("stronghold_cache");
    public static final TFTreasure STRONGHOLD_ROOM = new TFTreasure("stronghold_room");
    public static final TFTreasure STRONGHOLD_BOSS = new TFTreasure("stronghold_boss");
    public static final TFTreasure AURORA_CACHE = new TFTreasure("aurora_cache");
    public static final TFTreasure AURORA_ROOM = new TFTreasure("aurora_room");
    public static final TFTreasure TROLL_GARDEN = new TFTreasure("troll_garden");
    public static final TFTreasure TROLL_VAULT = new TFTreasure("troll_vault");
    public static final TFTreasure GRAVEYARD = new TFTreasure("graveyard");
    public static final TFTreasure QUEST_GROVE = new TFTreasure("quest_grove_dropper");
    public static final TFTreasure USELESS_LOOT = new TFTreasure("useless");
    public static final class_2960 BIGHORN_SHEEP_WHITE = TFTreasure.register("entities/bighorn_sheep/white");
    public static final class_2960 BIGHORN_SHEEP_ORANGE = TFTreasure.register("entities/bighorn_sheep/orange");
    public static final class_2960 BIGHORN_SHEEP_MAGENTA = TFTreasure.register("entities/bighorn_sheep/magenta");
    public static final class_2960 BIGHORN_SHEEP_LIGHT_BLUE = TFTreasure.register("entities/bighorn_sheep/light_blue");
    public static final class_2960 BIGHORN_SHEEP_YELLOW = TFTreasure.register("entities/bighorn_sheep/yellow");
    public static final class_2960 BIGHORN_SHEEP_LIME = TFTreasure.register("entities/bighorn_sheep/lime");
    public static final class_2960 BIGHORN_SHEEP_PINK = TFTreasure.register("entities/bighorn_sheep/pink");
    public static final class_2960 BIGHORN_SHEEP_GRAY = TFTreasure.register("entities/bighorn_sheep/gray");
    public static final class_2960 BIGHORN_SHEEP_LIGHT_GRAY = TFTreasure.register("entities/bighorn_sheep/light_gray");
    public static final class_2960 BIGHORN_SHEEP_CYAN = TFTreasure.register("entities/bighorn_sheep/cyan");
    public static final class_2960 BIGHORN_SHEEP_PURPLE = TFTreasure.register("entities/bighorn_sheep/purple");
    public static final class_2960 BIGHORN_SHEEP_BLUE = TFTreasure.register("entities/bighorn_sheep/blue");
    public static final class_2960 BIGHORN_SHEEP_BROWN = TFTreasure.register("entities/bighorn_sheep/brown");
    public static final class_2960 BIGHORN_SHEEP_GREEN = TFTreasure.register("entities/bighorn_sheep/green");
    public static final class_2960 BIGHORN_SHEEP_RED = TFTreasure.register("entities/bighorn_sheep/red");
    public static final class_2960 BIGHORN_SHEEP_BLACK = TFTreasure.register("entities/bighorn_sheep/black");
    public static final class_2960 QUESTING_RAM_REWARDS = TFTreasure.register("entities/questing_ram_rewards");
    public static final class_2960 DEATH_TOME_HURT = TFTreasure.register("entities/death_tome_hurt");
    public static final class_2960 DEATH_TOME_BOOKS = TFTreasure.register("entities/death_tome_books");
    public static final class_2960 ALL_BOSSES = TFTreasure.register("entities/all_bosses");
    public static class_5339 ENCHANT;
    public static class_5339 ITEM_OR_DEFAULT;
    public static class_5342 IS_MINION;
    public static class_5342 MOD_EXISTS;
    public final class_2960 lootTable;

    private TFTreasure(String path) {
        this.lootTable = TwilightForestMod.prefix(String.format("structures/%s", path));
    }

    public static void init() {
        ENCHANT = TFTreasure.registerFunction("enchant", new class_5339((class_5335)new Enchant.Serializer()));
        ITEM_OR_DEFAULT = TFTreasure.registerFunction("item_or_default", new class_5339((class_5335)new ModItemSwap.Serializer()));
        IS_MINION = TFTreasure.registerCondition("is_minion", new class_5342((class_5335)new IsMinion.ConditionSerializer()));
        MOD_EXISTS = TFTreasure.registerCondition("mod_exists", new class_5342((class_5335)new ModExists.ConditionSerializer()));
    }

    public void generateChest(class_5281 world, class_2338 pos, class_2350 dir, boolean trapped) {
        this.generateLootContainer(world, pos, (class_2680)(trapped ? class_2246.field_10380 : class_2246.field_10034).method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir), 2);
    }

    public void generateLootContainer(class_5281 world, class_2338 pos, class_2680 state, int flags) {
        world.method_8652(pos, state, flags);
        this.generateChestContents(world, pos);
    }

    public void generateLootContainer(class_1936 world, class_2338 pos, class_2680 state, int flags, long seed) {
        world.method_8652(pos, state, flags);
        this.generateChestContents(world, pos, seed);
    }

    public void generateChestContents(class_5281 world, class_2338 pos) {
        this.generateChestContents((class_1936)world, pos, world.method_8412() * (long)pos.method_10263() + (long)pos.method_10264() ^ (long)pos.method_10260());
    }

    public void generateChestContents(class_1936 world, class_2338 pos, long seed) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2621) {
            class_2621 lootContainer = (class_2621)class_25862;
            lootContainer.method_11285(this.lootTable, seed);
        }
    }

    private static class_5339 registerFunction(String name, class_5339 function) {
        return (class_5339)class_2378.method_10230((class_2378)class_2378.field_25294, (class_2960)TwilightForestMod.prefix(name), (Object)function);
    }

    private static class_5342 registerCondition(String name, class_5342 condition) {
        return (class_5342)class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)TwilightForestMod.prefix(name), (Object)condition);
    }

    private static class_2960 register(String id) {
        return TFTreasure.register(TwilightForestMod.prefix(id));
    }

    private static class_2960 register(class_2960 id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }

    public static void entityDropsIntoContainer(class_1309 entity, class_47 lootContext, class_2680 blockContaining, class_2338 placement) {
        class_3218 serverLevel;
        class_1937 class_19372 = entity.field_6002;
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_8652(placement, blockContaining, 2) && (class_19372 = serverLevel.method_8321(placement)) instanceof class_1263) {
            class_1263 container = (class_1263)class_19372;
            serverLevel.method_8503().method_3857().method_367(entity.method_5989()).method_329(container, lootContext);
        }
    }
}

